#include <iostream>
#include <vector>

using namespace std;


struct Point {
    long long x, y;
};

pair<int, int> get_direction_vector(int direction) {
    if (direction == 0) return {0, 1};   
    if (direction == 1) return {1, 0};   
    if (direction == 2) return {0, -1};  
    if (direction == 3) return {-1, 0};  
    return {0, 0};
}


bool check_collision(const Point& p1, int dir1, const Point& p2, int dir2) {
    pair<int, int> v1 = get_direction_vector(dir1);
    pair<int, int> v2 = get_direction_vector(dir2);

    long long dx1 = v1.first;
    long long dy1 = v1.second;
    long long dx2 = v2.first;
    long long dy2 = v2.second;


    long long delta_x = p2.x - p1.x; 
    long long delta_y = p2.y - p1.y; 

    long long delta_dx = dx1 - dx2;
    long long delta_dy = dy1 - dy2;

    long long t_x = -2; 
    long long t_y = -2; 

    if (delta_dx == 0) {
        if (delta_x == 0) {
            t_x = -1; 
        } else {
            return false; 
        }
    } else {
        if (delta_x % delta_dx != 0 || delta_x / delta_dx < 1) {
            return false;
        }
        t_x = delta_x / delta_dx;
    }

    if (delta_dy == 0) {
        if (delta_y == 0) {
            t_y = -1;
        } else {
            return false; 
        }
    } else {
        if (delta_y % delta_dy != 0 || delta_y / delta_dy < 1) {
            return false;
        }
        t_y = delta_y / delta_dy;
    }

    if (t_x == -1 && t_y == -1) {

        return false;
    } 
    
    if (t_x == -1) { 

        return t_y >= 1; 
    }
    
    if (t_y == -1) {

        return t_x >= 1; 
    }
    return t_x == t_y;
}


int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int N;
    if (!(cin >> N)) return 0;

    vector<Point> points(N);
    for (int i = 0; i < N; ++i) {
        cin >> points[i].x >> points[i].y;
    }
    long long total_hellos = 0;

    for (int i = 0; i < N; ++i) {
        for (int j = i + 1; j < N; ++j) {

            for (int dir_i = 0; dir_i < 4; ++dir_i) {
                for (int dir_j = 0; dir_j < 4; ++dir_j) {
                    
                    if (check_collision(points[i], dir_i, points[j], dir_j)) {
                        total_hellos++;
                    }
                }
            }
        }
    }

    cout << total_hellos << endl;

    return 0;
}